"use client"

import { Dialog } from "@/components/ui/dialog"
import { useApplicationWorkflow } from "@/hooks/use-application-workflow"
import { TransformedAgencies } from "@/types/transformers"
import { ComponentWithClassName } from "@/types/utils"
import { WorkflowOption } from "@/types/workflow"
import { TransformedStatewideServices } from "../type/transformers"
import { WorkflowDialogAdd } from "./workflow.dialog-add"
import { WorkflowDialogDelete } from "./workflow.dialog-delete"
import { WorkflowDialogView } from "./workflow.dialog-view"
import { WorkflowDialogUpdate } from "./workflow.dialog-update"

export function WorkflowDialog(props: ComponentWithClassName<{ data: NonNullable<TransformedStatewideServices>, agencies: TransformedAgencies }>) {
  const {
    resetWorkflow,
    workflow,
  } = useApplicationWorkflow()

  if (!workflow) {
    return
  }

  const content = INTERNAL__WorkflowDialogContent(workflow, props, resetWorkflow)
  return content && (
    <Dialog open defaultOpen onOpenChange={resetWorkflow}>
      {content}
    </Dialog>
  )
}

function INTERNAL__WorkflowDialogContent(workflow: NonNullable<WorkflowOption>, { data, agencies, className }: ComponentWithClassName<{ data: NonNullable<TransformedStatewideServices>, agencies: TransformedAgencies }>, setClose: () => void) {
  if (workflow.__tag === "ADD_SERVICE") {
    return (
      <WorkflowDialogAdd setClose={setClose} agencies={agencies} className={className} />
    )
  }

  if (workflow.__tag === "VIEW_SERVICES") {
    const potential = data.find((d) => d.id === workflow.id)
    return !!potential ? (
      <WorkflowDialogView data={potential} className={className} />
    ) : null
  }

  if (workflow.__tag === "UPDATE_SERVICE") {
    const potential = data.find((d) => d.id === workflow.id)
    return !!potential ? (
      <WorkflowDialogUpdate data={potential} setClose={setClose} agencies={agencies} className={className} />
    ) : null
  }

  if (workflow.__tag === "DELETE_SERVICE") {
    const potential = data.find((d) => d.id === workflow.id)
    return !!potential ? (
      <WorkflowDialogDelete data={potential} setClose={setClose} className={className} />
    ) : null
  }

  return null
}
